#include "wch_common.h"

#define PCIE_UART_MAX 28

struct pci_board wch_pci_board_conf[] = {
	/* NONE */
	{
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		"none",
		BOARDFLAG_NONE,
		{
			{ 'n', -1, 0, 0, -1, 0, 0, NONE_BOARD, 0 },
		},
	},

	/* CH351_2S */
	{
		VENDOR_ID_WCH_CH351,
		DEVICE_ID_WCH_CH351_2S,
		SUB_VENDOR_ID_WCH_CH351,
		SUB_DEVICE_ID_WCH_CH351_2S,
		0x02,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		"CH351_2S",
		BOARDFLAG_REMAP,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH351_2S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH351_2S, 0 },
		},
	},

	/* CH352_2S */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH352_2S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH352_2S,
		0x02,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		"CH352_2S",
		BOARDFLAG_REMAP,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH352_2S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH352_2S, 0 },
		},
	},

	/* CH352_1S1P */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH352_1S1P,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH352_1S1P,
		1,
		0,
		0x00,
		0x00,
		0x00,
		0x00,
		"CH352_1S1P",
		BOARDFLAG_REMAP,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH352_1S1P, 0 },
		},
	},

	/* CH353_4S */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH353_4S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH353_4S,
		4,
		3,
		0x0F,
		0x00,
		0x00,
		0x00,
		"CH353_4S",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH353_4S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH353_4S, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH353_4S, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH353_4S, 0 },

		},
	},

	/* CH353_2S1P */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH353_2S1P,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH353_2S1P,
		2,
		3,
		0x0F,
		0x00,
		0x00,
		0x00,
		"CH353_2S1P",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH353_2S1P, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH353_2S1P, 0 },
		},
	},

	/* CH353_2S1PAR */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH353_2S1PAR,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH353_2S1PAR,
		2,
		3,
		0x0F,
		0x00,
		0x00,
		0x00,
		"CH353_2S1PAR",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH353_2S1PAR,
			  0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH353_2S1PAR,
			  0 },
		},
	},

	/* CH355_4S */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH355_4S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH355_4S,
		4,
		4,
		0x20,
		0x00,
		0x00,
		0x00,
		"CH355_4S",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH355_4S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH355_4S, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH355_4S, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH355_4S, 0 },

		},
	},

	/* CH356_4S1P */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH356_4S1P,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH356_4S1P,
		4,
		4,
		0x3F,
		0x00,
		0x00,
		0x00,
		"CH356_4S1P",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH356_4S1P, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH356_4S1P, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH356_4S1P, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH356_4S1P, 0 },
		},
	},

	/* CH356_6S(CH356+CH432(1P)) */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH356_6S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH356_6S,
		6,
		4,
		0x3F,
		0x00,
		0x00,
		0x00,
		"CH356_6S",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH356_6S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH356_6S, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH356_6S, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH356_6S, 0 },
			{ 's', 4, 0, 8, -1, 0, 0, WCH_BOARD_CH356_6S, 0 },
			{ 's', 4, 0x08, 8, -1, 0, 0, WCH_BOARD_CH356_6S,
			  0 },
		},
	},

	/* CH356_8S(CH356+CH432(2P)) */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH356_8S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH356_8S,
		8,
		4,
		0x3F,
		0x00,
		0x00,
		0x00,
		"CH356_8S",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH356_8S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH356_8S, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH356_8S, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH356_8S, 0 },
			{ 's', 4, 0, 8, -1, 0, 0, WCH_BOARD_CH356_8S, 0 },
			{ 's', 4, 0x08, 8, -1, 0, 0, WCH_BOARD_CH356_8S,
			  0 },
			{ 's', 4, 0x10, 8, -1, 0, 0, WCH_BOARD_CH356_8S,
			  0 },
			{ 's', 4, 0x18, 8, -1, 0, 0, WCH_BOARD_CH356_8S,
			  0 },
		},
	},

	/* CH357_4S */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH357_4S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH357_4S,
		4,
		4,
		0x6F,
		0x00,
		0x00,
		0x00,
		"CH357_4S",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH357_4S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH357_4S, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH357_4S, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH357_4S, 0 },
		},
	},

	/* CH358_4S1P */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH358_4S1P,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH358_4S1P,
		4,
		4,
		0x6F,
		0x00,
		0x00,
		0x00,
		"CH358_4S1P",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH358_4S1P, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH358_4S1P, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH358_4S1P, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH358_4S1P, 0 },
		},
	},

	/* CH358_8S */
	{

		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH358_8S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH358_8S,
		8,
		4,
		0x6F,
		0x00,
		0x00,
		0x00,
		"CH358_8S",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH358_8S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH358_8S, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH358_8S, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH358_8S, 0 },
			{ 's', 0, 8, 8, -1, 0, 0, WCH_BOARD_CH358_8S, 0 },
			{ 's', 1, 8, 8, -1, 0, 0, WCH_BOARD_CH358_8S, 0 },
			{ 's', 2, 8, 8, -1, 0, 0, WCH_BOARD_CH358_8S, 0 },
			{ 's', 3, 8, 8, -1, 0, 0, WCH_BOARD_CH358_8S, 0 },
		},
	},

	/* CH359_16S */
	{

		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH359_16S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH359_16S,
		16,
		4,
		0x6F,
		0x00,
		0x00,
		0x00,
		"CH359_16S",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 1, 0, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 2, 0, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 3, 0, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 0, 8, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 1, 8, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 2, 8, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 3, 8, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },

			{ 's', 4, 0, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 4, 16, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 4, 32, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 4, 48, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 4, 8, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 4, 24, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 4, 40, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
			{ 's', 4, 56, 8, -1, 0, 0, WCH_BOARD_CH359_16S, 0 },
		},
	},

	/* CH382_2S */
	{

		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH382_2S,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH382_2S,
		2,
		0,
		0xE9,
		0x00,
		0x00,
		0x00,
		"CH382_2S",
		BOARDFLAG_NONE,
		{

			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH382_2S,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH382_2S,
			  0 },
		},
	},

	/* CH382_2S1P */
	{
		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH382_2S1P,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH382_2S1P,
		2,
		0,
		0xE9,
		0x00,
		0x00,
		0x00,
		"CH382_2S1P",
		BOARDFLAG_NONE,
		{

			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH382_2S1P,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH382_2S1P,
			  0 },
		},
	},

	/* CH384_4S */
	{

		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH384_4S,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH384_4S,
		4,
		0,
		0xE9,
		0x00,
		0x00,
		0x00,
		"CH384_4S",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH384_4S,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH384_4S,
			  0 },
			{ 's', 0, 0xD0, 8, -1, 0, 0, WCH_BOARD_CH384_4S,
			  0 },
			{ 's', 0, 0xD8, 8, -1, 0, 0, WCH_BOARD_CH384_4S,
			  0 },
		},
	},

	/* CH384_4S1P */
	{
		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH384_4S1P,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH384_4S1P,
		4,
		0,
		0xE9,
		0x00,
		0x00,
		0x00,
		"CH384_4S1P",
		BOARDFLAG_NONE,
		{
			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH384_4S1P,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH384_4S1P,
			  0 },
			{ 's', 0, 0xD0, 8, -1, 0, 0, WCH_BOARD_CH384_4S1P,
			  0 },
			{ 's', 0, 0xD8, 8, -1, 0, 0, WCH_BOARD_CH384_4S1P,
			  0 },
		},
	},

	/* CH384_8S */
	{
		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH384_8S,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH384_8S,
		8,
		0,
		0xE0,
		0x00,
		0x00,
		0x00,
		"CH384_8S",
		BOARDFLAG_CH384_8_PORTS,
		{
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH384_8S,
			  0 },
			{ 's', 0, 0x10, 8, -1, 0, 0, WCH_BOARD_CH384_8S,
			  0 },
			{ 's', 0, 0x20, 8, -1, 0, 0, WCH_BOARD_CH384_8S,
			  0 },
			{ 's', 0, 0x30, 8, -1, 0, 0, WCH_BOARD_CH384_8S,
			  0 },
			{ 's', 0, 0x08, 8, -1, 0, 0, WCH_BOARD_CH384_8S,
			  0 },
			{ 's', 0, 0x18, 8, -1, 0, 0, WCH_BOARD_CH384_8S,
			  0 },
			{ 's', 0, 0x28, 8, -1, 0, 0, WCH_BOARD_CH384_8S,
			  0 },
			{ 's', 0, 0x38, 8, -1, 0, 0, WCH_BOARD_CH384_8S,
			  0 },
		},
	},

	/* CH384_28S */
	{
		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH384_28S,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH384_28S,
		PCIE_UART_MAX,
		0,
		0xE9,
		0xE0,
		0xE4,
		0xE6,
		"CH384_28S",
		BOARDFLAG_CH384_28_PORTS,
		{
			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0xD0, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0xD8, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },

			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x10, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x20, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x30, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x08, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x18, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x28, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x38, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },

			{ 's', 0, 0x40, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x50, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x60, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x70, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x48, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x58, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x68, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x78, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },

			{ 's', 0, 0x80, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x90, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0xA0, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0xB0, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x88, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0x98, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0xA8, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
			{ 's', 0, 0xB8, 8, -1, 0, 0, WCH_BOARD_CH384_28S,
			  0 },
		},
	},

	/* CH365_32S */
	{
		VENDOR_ID_WCH_PCI,
		DEVICE_ID_WCH_CH365_32S,
		SUB_VENDOR_ID_WCH_PCI,
		SUB_DEVICE_ID_WCH_CH365_32S,
		32,
		1,
		0x00,
		0x00,
		0x00,
		0x00,
		"CH365_32S",
		BOARDFLAG_CH365_32_PORTS,
		{
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },

			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 0, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },

			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },

			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH365_32S,
			  0 },
		},
	},

	/* CH384_8HS */
	{
		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH384_8HS,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH384_8HS,
		8,
		0,
		0xE9,
		0xE0,
		0x00,
		0x00,
		"CH384_8HS",
		BOARDFLAG_CH384_8H_PORTS,
		{
			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH384_8HS,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH384_8HS,
			  0 },
			{ 's', 0, 0xD0, 8, -1, 0, 0, WCH_BOARD_CH384_8HS,
			  0 },
			{ 's', 0, 0xD8, 8, -1, 0, 0, WCH_BOARD_CH384_8HS,
			  0 },
			{ 's', 0, 0x20, 8, -1, 0, 0, WCH_BOARD_CH384_8HS,
			  0 },
			{ 's', 0, 0x30, 8, -1, 0, 0, WCH_BOARD_CH384_8HS,
			  0 },
			{ 's', 0, 0x08, 8, -1, 0, 0, WCH_BOARD_CH384_8HS,
			  0 },
			{ 's', 0, 0x18, 8, -1, 0, 0, WCH_BOARD_CH384_8HS,
			  0 },
		},
	},

	/* CH384_10HS */
	{
		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH384_10HS,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH384_10HS,
		10,
		0,
		0xE9,
		0xE0,
		0x00,
		0x00,
		"CH384_10HS",
		BOARDFLAG_CH384_10H_PORTS,
		{
			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0xD0, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0xD8, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0x10, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0x20, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0x30, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0x08, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0x18, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
			{ 's', 0, 0x28, 8, -1, 0, 0, WCH_BOARD_CH384_10HS,
			  0 },
		},
	},

	/* CH384_16HS */
	{
		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH384_16HS,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH384_16HS,
		16,
		0,
		0xE9,
		0xE0,
		0xE4,
		0x00,
		"CH384_16HS",
		BOARDFLAG_CH384_16H_PORTS,
		{
			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0xD0, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0xD8, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },

			{ 's', 0, 0x10, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x20, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x30, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x08, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x18, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x28, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x38, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },

			{ 's', 0, 0x50, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x60, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x70, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x48, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
			{ 's', 0, 0x58, 8, -1, 0, 0, WCH_BOARD_CH384_16HS,
			  0 },
		},
	},

	/* CH384_20S */
	{
		VENDOR_ID_WCH_PCIE,
		DEVICE_ID_WCH_CH384_20S,
		SUB_VENDOR_ID_WCH_PCIE,
		SUB_DEVICE_ID_WCH_CH384_20S,
		20,
		0,
		0xE9,
		0xE0,
		0xE4,
		0xE6,
		"CH384_20S",
		BOARDFLAG_CH384_20H_PORTS,
		{
			{ 's', 0, 0xC0, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0xC8, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0xD0, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0xD8, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },

			{ 's', 0, 0x00, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x10, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x20, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x30, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x08, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x18, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x28, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x38, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },

			{ 's', 0, 0x40, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x50, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x60, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x70, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x48, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x58, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x68, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
			{ 's', 0, 0x78, 8, -1, 0, 0, WCH_BOARD_CH384_20S,
			  0 },
		},
	},

};
